---
generated_at: 2026-02-03 10:10:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-アプリケーションラッパー (_app)

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/pages/_app.tsx` L26-32 - appGetInitialProps関数
- E-02: `packages/next/src/pages/_app.tsx` L34-46 - Appクラス定義
- E-03: `packages/next/src/pages/_app.tsx` L38-39 - origGetInitialPropsとgetInitialProps
- E-04: `packages/next/src/pages/_app.tsx` L14-20 - エクスポートされる型定義
- E-05: `packages/next/src/shared/lib/utils.ts` L361-411 - loadGetInitialProps関数
- E-06: `packages/next/src/shared/lib/utils.ts` L163-182 - AppContextType, AppInitialProps, AppPropsType型
- E-07: `packages/next/src/shared/lib/utils.ts` L44-63 - NextWebVitalsMetric型
- E-08: `docs/code-to-docs/画面一覧/画面一覧.csv` L4 - 画面情報定義
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` L10-12 - 関連機能情報
- E-10: `docs/code-to-docs/画面一覧/画面遷移図.md` L13-23 - Pages Router遷移図

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 全ページを包む共通コンポーネントとして機能する | E-02, E-08 | ○ |
| C-02 | getInitialPropsでloadGetInitialPropsを通じてページpropsを取得 | E-01, E-05 | ○ |
| C-03 | renderメソッドでComponentとpagePropsを展開してレンダリング | E-02 | ○ |
| C-04 | origGetInitialPropsに元の関数が保持される | E-03 | ○ |
| C-05 | React.Componentクラスを継承 | E-02 | ○ |
| C-06 | ジェネリクスP,CP,Sでパラメータ化 | E-02 | ○ |
| C-07 | AppType,AppProps,AppContext等の型がエクスポートされる | E-04 | ○ |
| C-08 | NextWebVitalsMetricがCLS,FCP,FID,INP,LCP,TTFBを含む | E-07 | ○ |
| C-09 | loadGetInitialPropsがインスタンスメソッド定義を検出してエラー | E-05 | ○ |
| C-10 | getInitialPropsがない場合空オブジェクトを返す | E-05 | ○ |
| C-11 | 戻り値がnull/undefinedの場合エラーをスロー | E-05 | ○ |
| C-12 | 空オブジェクト返却時に開発環境で警告 | E-05 | ○ |
| C-13 | レスポンス送信済みの場合propsの検証をスキップ | E-05 | ○ |
| C-14 | Pages Routerで使用される | E-08, E-10 | ○ |
| C-15 | カスタムAppが主機能、Pages RouterとSSRが補助機能 | E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] loadGetInitialPropsのエラーハンドリングパターンが網羅されているか確認
- [ ] ジェネリクスの型パラメータ説明が正確か確認
- [ ] 画面遷移の記述が遷移図と一致するか確認
